/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import com.google.common.base.Throwables;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class CommandReplaceBlock
implements ISubCommand {
    public static ISubCommand instance = new CommandReplaceBlock();

    @Override
    public String getCommandName() {
        return "replaceblocks";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        int n;
        Block block;
        String string;
        int n2;
        int n3;
        int n4;
        int n5;
        if (stringArray.length < 7) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
        }
        World world = iCommandSender.getEntityWorld();
        if (world.isRemote) {
            return;
        }
        ChunkCoordinates chunkCoordinates = null;
        int n6 = 1;
        if ("@".equals(stringArray[n6])) {
            chunkCoordinates = iCommandSender.getPlayerCoordinates();
            int n7 = ++n6;
            n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n7]);
        } else {
            try {
                n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            }
            catch (Throwable throwable) {
                chunkCoordinates = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[n6 - 1]).getPlayerCoordinates();
                n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            }
        }
        int n8 = ++n6;
        int n9 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n8]);
        int n10 = ++n6;
        int n11 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n10]);
        int n12 = ++n6 + 1;
        try {
            n4 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            n3 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            n2 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
        }
        catch (Throwable throwable) {
            if (n6 > n12 || chunkCoordinates == null) {
                throw Throwables.propagate((Throwable)throwable);
            }
            --n6;
            n4 = n5;
            n3 = n9;
            n2 = n11;
        }
        if (chunkCoordinates != null) {
            n5 = chunkCoordinates.posX - n5;
            n9 = chunkCoordinates.posY - n9;
            n11 = chunkCoordinates.posZ - n11;
            n4 = chunkCoordinates.posX + n4;
            n3 = chunkCoordinates.posY + n3;
            n2 = chunkCoordinates.posZ + n2;
        }
        n9 &= ~n9 >> 31;
        n3 &= ~n3 >> 31;
        if (n4 < n5) {
            n12 = n5;
            n5 = n4;
            n4 = n12;
        }
        if (n3 < n9) {
            n12 = n9;
            n9 = n3;
            n3 = n12;
        }
        if (n2 < n11) {
            n12 = n11;
            n11 = n2;
            n2 = n12;
        }
        if (n9 > 255) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
            return;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        int n13 = 0;
        String string2 = string = stringArray[n6];
        n12 = string.indexOf(35);
        if (n12 > 0) {
            n13 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)string.substring(n12 + 1));
            string = string.substring(0, n12);
        }
        if ((block = Block.getBlockFromName((String)string)) == Blocks.air || n13 > 15 || n13 < 0) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
            return;
        }
        Block block2 = block;
        int n14 = n13;
        long l = ((long)n4 - (long)n5) * ((long)n3 - (long)n9) * ((long)n2 - (long)n11);
        CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.replaceblocks.start", l, n5, n9, n11, n4, n3, n2, string2);
        block = new THashSet();
        l = 0L;
        int n15 = stringArray.length;
        while (n6 < n15) {
            int n16;
            int n17;
            String string3 = stringArray[n6];
            if (string3.charAt(0) == '*') {
                if (string3.equals("*fluid")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n18 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block3 = chunk.getBlock(n17, n16, n18);
                                if (!block3.getMaterial().isLiquid() || !chunk.func_150807_a(n17, n16, n18, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*tree")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n19 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block4 = chunk.getBlock(n17, n16, n19);
                                if (!block4.isWood((IBlockAccess)world, n, n16, i) && !block4.isLeaves((IBlockAccess)world, n, n16, i) || !chunk.func_150807_a(n17, n16, n19, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.startsWith("*repl")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n20 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block5 = chunk.getBlock(n17, n16, n20);
                                if (!block5.isReplaceable((IBlockAccess)world, n, n16, i) || !chunk.func_150807_a(n17, n16, n20, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*stone")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n21 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block6 = chunk.getBlock(n17, n16, n21);
                                if (!block6.isReplaceableOreGen(world, n, n16, i, Blocks.stone) && !block6.isReplaceableOreGen(world, n, n16, i, Blocks.netherrack) && !block6.isReplaceableOreGen(world, n, n16, i, Blocks.end_stone) || !chunk.func_150807_a(n17, n16, n21, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*rock")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n22 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block7 = chunk.getBlock(n17, n16, n22);
                                if (block7.getMaterial() != Material.rock || !chunk.func_150807_a(n17, n16, n22, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*sand")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n23 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block8 = chunk.getBlock(n17, n16, n23);
                                if (block8.getMaterial() != Material.sand || !chunk.func_150807_a(n17, n16, n23, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*dirt")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n24 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block9 = chunk.getBlock(n17, n16, n24);
                                Material material = block9.getMaterial();
                                if (material != Material.grass && material != Material.ground && material != Material.clay && material != Material.snow && material != Material.craftedSnow && material != Material.ice && material != Material.packedIce || !chunk.func_150807_a(n17, n16, n24, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.startsWith("*plant")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n25 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block10 = chunk.getBlock(n17, n16, n25);
                                Material material = block10.getMaterial();
                                if (material != Material.plants && material != Material.vine && material != Material.cactus && material != Material.leaves || !chunk.func_150807_a(n17, n16, n25, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                } else if (string3.equals("*fire")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n17 = n & 0xF;
                            int n26 = i & 0xF;
                            for (n16 = n9; n16 <= n3; ++n16) {
                                Block block11 = chunk.getBlock(n17, n16, n26);
                                Material material = block11.getMaterial();
                                if (material != Material.fire && material != Material.lava && !block11.isBurning((IBlockAccess)world, n, n16, i) || !chunk.func_150807_a(n17, n16, n26, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                }
            } else {
                Block block12;
                n = -1;
                n12 = string3.indexOf(35);
                if (n12 > 0) {
                    n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)string3.substring(n12 + 1));
                    string3 = string3.substring(0, n12);
                }
                if ((block12 = Block.getBlockFromName((String)string3)) != Blocks.air) {
                    for (int i = n5; i <= n4; ++i) {
                        for (n17 = n11; n17 <= n2; ++n17) {
                            Chunk chunk = world.getChunkFromBlockCoords(i, n17);
                            n16 = i & 0xF;
                            int n27 = n17 & 0xF;
                            for (int j = n9; j <= n3; ++j) {
                                boolean bl;
                                boolean bl2 = bl = n == -1 || chunk.getBlockMetadata(n16, j, n27) == n;
                                if (!bl || chunk.getBlock(n16, j, n27) != block12 || !chunk.func_150807_a(n16, j, n27, block2, n14)) continue;
                                ++l;
                                block.add((Object)chunk);
                            }
                        }
                    }
                }
            }
            ++n6;
        }
        if (!block.isEmpty()) {
            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.replaceblocks.success", l, n5, n9, n11, n4, n3, n2, string2);
        } else {
            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.replaceblocks.failure", new Object[0]);
        }
        if (world instanceof WorldServer) {
            TObjectHashIterator tObjectHashIterator = block.iterator();
            n = block.size();
            for (int i = 0; i < n; ++i) {
                Chunk chunk = (Chunk)tObjectHashIterator.next();
                PlayerManager playerManager = ((WorldServer)world).getPlayerManager();
                if (playerManager == null) {
                    return;
                }
                PlayerManager.PlayerInstance playerInstance = playerManager.getOrCreateChunkWatcher(chunk.xPosition, chunk.zPosition, false);
                if (playerInstance == null) continue;
                playerInstance.sendToAllPlayersWatchingChunk((Packet)new S21PacketChunkData(chunk, false, -1));
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        return null;
    }
}

